package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.EventBridgeActionName
import scala.jdk.CollectionConverters._
final case class EventBridgeActionDefinition(name: EventBridgeActionName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EventBridgeActionDefinition = {
    import EventBridgeActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EventBridgeActionDefinition
      .builder()
      .name(EventBridgeActionName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.EventBridgeActionDefinition.ReadOnly =
    zio.aws.connect.model.EventBridgeActionDefinition.wrap(buildAwsValue())
}
object EventBridgeActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EventBridgeActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EventBridgeActionDefinition =
      zio.aws.connect.model.EventBridgeActionDefinition(name)
    def name: EventBridgeActionName
    def getName: ZIO[Any, Nothing, EventBridgeActionName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EventBridgeActionDefinition
  ) extends zio.aws.connect.model.EventBridgeActionDefinition.ReadOnly {
    override val name: EventBridgeActionName =
      zio.aws.connect.model.primitives.EventBridgeActionName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EventBridgeActionDefinition
  ): zio.aws.connect.model.EventBridgeActionDefinition.ReadOnly = new Wrapper(
    impl
  )
}
