package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait EventSourceName {
  def unwrap: software.amazon.awssdk.services.connect.model.EventSourceName
}
object EventSourceName {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.EventSourceName
  ): zio.aws.connect.model.EventSourceName = value match {
    case software.amazon.awssdk.services.connect.model.EventSourceName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.EventSourceName.ON_POST_CALL_ANALYSIS_AVAILABLE =>
      val r = OnPostCallAnalysisAvailable
      r
    case software.amazon.awssdk.services.connect.model.EventSourceName.ON_REAL_TIME_CALL_ANALYSIS_AVAILABLE =>
      val r = OnRealTimeCallAnalysisAvailable
      r
    case software.amazon.awssdk.services.connect.model.EventSourceName.ON_POST_CHAT_ANALYSIS_AVAILABLE =>
      val r = OnPostChatAnalysisAvailable
      r
    case software.amazon.awssdk.services.connect.model.EventSourceName.ON_ZENDESK_TICKET_CREATE =>
      val r = OnZendeskTicketCreate
      r
    case software.amazon.awssdk.services.connect.model.EventSourceName.ON_ZENDESK_TICKET_STATUS_UPDATE =>
      val r = OnZendeskTicketStatusUpdate
      r
    case software.amazon.awssdk.services.connect.model.EventSourceName.ON_SALESFORCE_CASE_CREATE =>
      val r = OnSalesforceCaseCreate
      r
    case software.amazon.awssdk.services.connect.model.EventSourceName.ON_CONTACT_EVALUATION_SUBMIT =>
      val r = OnContactEvaluationSubmit
      r
    case software.amazon.awssdk.services.connect.model.EventSourceName.ON_METRIC_DATA_UPDATE =>
      val r = OnMetricDataUpdate
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.EventSourceName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.EventSourceName =
      software.amazon.awssdk.services.connect.model.EventSourceName.UNKNOWN_TO_SDK_VERSION
  }
  case object OnPostCallAnalysisAvailable
      extends zio.aws.connect.model.EventSourceName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.EventSourceName =
      software.amazon.awssdk.services.connect.model.EventSourceName.ON_POST_CALL_ANALYSIS_AVAILABLE
  }
  case object OnRealTimeCallAnalysisAvailable
      extends zio.aws.connect.model.EventSourceName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.EventSourceName =
      software.amazon.awssdk.services.connect.model.EventSourceName.ON_REAL_TIME_CALL_ANALYSIS_AVAILABLE
  }
  case object OnPostChatAnalysisAvailable
      extends zio.aws.connect.model.EventSourceName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.EventSourceName =
      software.amazon.awssdk.services.connect.model.EventSourceName.ON_POST_CHAT_ANALYSIS_AVAILABLE
  }
  case object OnZendeskTicketCreate
      extends zio.aws.connect.model.EventSourceName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.EventSourceName =
      software.amazon.awssdk.services.connect.model.EventSourceName.ON_ZENDESK_TICKET_CREATE
  }
  case object OnZendeskTicketStatusUpdate
      extends zio.aws.connect.model.EventSourceName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.EventSourceName =
      software.amazon.awssdk.services.connect.model.EventSourceName.ON_ZENDESK_TICKET_STATUS_UPDATE
  }
  case object OnSalesforceCaseCreate
      extends zio.aws.connect.model.EventSourceName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.EventSourceName =
      software.amazon.awssdk.services.connect.model.EventSourceName.ON_SALESFORCE_CASE_CREATE
  }
  case object OnContactEvaluationSubmit
      extends zio.aws.connect.model.EventSourceName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.EventSourceName =
      software.amazon.awssdk.services.connect.model.EventSourceName.ON_CONTACT_EVALUATION_SUBMIT
  }
  case object OnMetricDataUpdate extends zio.aws.connect.model.EventSourceName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.EventSourceName =
      software.amazon.awssdk.services.connect.model.EventSourceName.ON_METRIC_DATA_UPDATE
  }
}
