package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.ResourceArnOrId
import scala.jdk.CollectionConverters._
final case class FilterV2(
    filterKey: Optional[ResourceArnOrId] = Optional.Absent,
    filterValues: Optional[Iterable[ResourceArnOrId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.FilterV2 = {
    import FilterV2.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.FilterV2
      .builder()
      .optionallyWith(
        filterKey.map(value => ResourceArnOrId.unwrap(value): java.lang.String)
      )(_.filterKey)
      .optionallyWith(
        filterValues.map(value =>
          value.map { item =>
            ResourceArnOrId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.filterValues)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.FilterV2.ReadOnly =
    zio.aws.connect.model.FilterV2.wrap(buildAwsValue())
}
object FilterV2 {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.FilterV2] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.FilterV2 = zio.aws.connect.model
      .FilterV2(filterKey.map(value => value), filterValues.map(value => value))
    def filterKey: Optional[ResourceArnOrId]
    def filterValues: Optional[List[ResourceArnOrId]]
    def getFilterKey: ZIO[Any, AwsError, ResourceArnOrId] =
      AwsError.unwrapOptionField("filterKey", filterKey)
    def getFilterValues: ZIO[Any, AwsError, List[ResourceArnOrId]] =
      AwsError.unwrapOptionField("filterValues", filterValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.FilterV2
  ) extends zio.aws.connect.model.FilterV2.ReadOnly {
    override val filterKey: Optional[ResourceArnOrId] = zio.aws.core.internal
      .optionalFromNullable(impl.filterKey())
      .map(value => zio.aws.connect.model.primitives.ResourceArnOrId(value))
    override val filterValues: Optional[List[ResourceArnOrId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.primitives.ResourceArnOrId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.FilterV2
  ): zio.aws.connect.model.FilterV2.ReadOnly = new Wrapper(impl)
}
