package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{AttributeValue, AttributeName}
import scala.jdk.CollectionConverters._
final case class GetContactAttributesResponse(
    attributes: Optional[Map[AttributeName, AttributeValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetContactAttributesResponse = {
    import GetContactAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetContactAttributesResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.GetContactAttributesResponse.ReadOnly =
    zio.aws.connect.model.GetContactAttributesResponse.wrap(buildAwsValue())
}
object GetContactAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetContactAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetContactAttributesResponse =
      zio.aws.connect.model
        .GetContactAttributesResponse(attributes.map(value => value))
    def attributes: Optional[Map[AttributeName, AttributeValue]]
    def getAttributes: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetContactAttributesResponse
  ) extends zio.aws.connect.model.GetContactAttributesResponse.ReadOnly {
    override val attributes: Optional[Map[AttributeName, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.connect.model.primitives.AttributeName(
                key
              ) -> zio.aws.connect.model.primitives.AttributeValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetContactAttributesResponse
  ): zio.aws.connect.model.GetContactAttributesResponse.ReadOnly = new Wrapper(
    impl
  )
}
