package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ApproximateTotalCount, NextToken}
import scala.jdk.CollectionConverters._
final case class GetCurrentUserDataResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    userDataList: Optional[Iterable[zio.aws.connect.model.UserData]] =
      Optional.Absent,
    approximateTotalCount: Optional[ApproximateTotalCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetCurrentUserDataResponse = {
    import GetCurrentUserDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetCurrentUserDataResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        userDataList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userDataList)
      .optionallyWith(
        approximateTotalCount.map(value =>
          ApproximateTotalCount.unwrap(value): java.lang.Long
        )
      )(_.approximateTotalCount)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.GetCurrentUserDataResponse.ReadOnly =
    zio.aws.connect.model.GetCurrentUserDataResponse.wrap(buildAwsValue())
}
object GetCurrentUserDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetCurrentUserDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetCurrentUserDataResponse =
      zio.aws.connect.model.GetCurrentUserDataResponse(
        nextToken.map(value => value),
        userDataList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        approximateTotalCount.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def userDataList: Optional[List[zio.aws.connect.model.UserData.ReadOnly]]
    def approximateTotalCount: Optional[ApproximateTotalCount]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getUserDataList
        : ZIO[Any, AwsError, List[zio.aws.connect.model.UserData.ReadOnly]] =
      AwsError.unwrapOptionField("userDataList", userDataList)
    def getApproximateTotalCount: ZIO[Any, AwsError, ApproximateTotalCount] =
      AwsError.unwrapOptionField("approximateTotalCount", approximateTotalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetCurrentUserDataResponse
  ) extends zio.aws.connect.model.GetCurrentUserDataResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val userDataList
        : Optional[List[zio.aws.connect.model.UserData.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userDataList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.UserData.wrap(item)
          }.toList
        )
    override val approximateTotalCount: Optional[ApproximateTotalCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approximateTotalCount())
        .map(value =>
          zio.aws.connect.model.primitives.ApproximateTotalCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetCurrentUserDataResponse
  ): zio.aws.connect.model.GetCurrentUserDataResponse.ReadOnly = new Wrapper(
    impl
  )
}
