package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{AgentResourceId, ARN, Url}
import scala.jdk.CollectionConverters._
final case class GetFederationTokenResponse(
    credentials: Optional[zio.aws.connect.model.Credentials] = Optional.Absent,
    signInUrl: Optional[Url] = Optional.Absent,
    userArn: Optional[ARN] = Optional.Absent,
    userId: Optional[AgentResourceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetFederationTokenResponse = {
    import GetFederationTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetFederationTokenResponse
      .builder()
      .optionallyWith(credentials.map(value => value.buildAwsValue()))(
        _.credentials
      )
      .optionallyWith(
        signInUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.signInUrl)
      .optionallyWith(
        userArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.userArn)
      .optionallyWith(
        userId.map(value => AgentResourceId.unwrap(value): java.lang.String)
      )(_.userId)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.GetFederationTokenResponse.ReadOnly =
    zio.aws.connect.model.GetFederationTokenResponse.wrap(buildAwsValue())
}
object GetFederationTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetFederationTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetFederationTokenResponse =
      zio.aws.connect.model.GetFederationTokenResponse(
        credentials.map(value => value.asEditable),
        signInUrl.map(value => value),
        userArn.map(value => value),
        userId.map(value => value)
      )
    def credentials: Optional[zio.aws.connect.model.Credentials.ReadOnly]
    def signInUrl: Optional[Url]
    def userArn: Optional[ARN]
    def userId: Optional[AgentResourceId]
    def getCredentials
        : ZIO[Any, AwsError, zio.aws.connect.model.Credentials.ReadOnly] =
      AwsError.unwrapOptionField("credentials", credentials)
    def getSignInUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("signInUrl", signInUrl)
    def getUserArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("userArn", userArn)
    def getUserId: ZIO[Any, AwsError, AgentResourceId] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetFederationTokenResponse
  ) extends zio.aws.connect.model.GetFederationTokenResponse.ReadOnly {
    override val credentials
        : Optional[zio.aws.connect.model.Credentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentials())
        .map(value => zio.aws.connect.model.Credentials.wrap(value))
    override val signInUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.signInUrl())
      .map(value => zio.aws.connect.model.primitives.Url(value))
    override val userArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.userArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val userId: Optional[AgentResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.connect.model.primitives.AgentResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetFederationTokenResponse
  ): zio.aws.connect.model.GetFederationTokenResponse.ReadOnly = new Wrapper(
    impl
  )
}
