package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  NextToken2500,
  GroupingV2,
  MaxResult100,
  Timestamp,
  ARN
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetMetricDataV2Request(
    resourceArn: ARN,
    startTime: Timestamp,
    endTime: Timestamp,
    filters: Iterable[zio.aws.connect.model.FilterV2],
    groupings: Optional[Iterable[GroupingV2]] = Optional.Absent,
    metrics: Iterable[zio.aws.connect.model.MetricV2],
    nextToken: Optional[NextToken2500] = Optional.Absent,
    maxResults: Optional[MaxResult100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetMetricDataV2Request = {
    import GetMetricDataV2Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetMetricDataV2Request
      .builder()
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .filters(filters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        groupings.map(value =>
          value.map { item =>
            GroupingV2.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groupings)
      .metrics(metrics.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken2500.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult100.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.GetMetricDataV2Request.ReadOnly =
    zio.aws.connect.model.GetMetricDataV2Request.wrap(buildAwsValue())
}
object GetMetricDataV2Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetMetricDataV2Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetMetricDataV2Request =
      zio.aws.connect.model.GetMetricDataV2Request(
        resourceArn,
        startTime,
        endTime,
        filters.map { item =>
          item.asEditable
        },
        groupings.map(value => value),
        metrics.map { item =>
          item.asEditable
        },
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceArn: ARN
    def startTime: Timestamp
    def endTime: Timestamp
    def filters: List[zio.aws.connect.model.FilterV2.ReadOnly]
    def groupings: Optional[List[GroupingV2]]
    def metrics: List[zio.aws.connect.model.MetricV2.ReadOnly]
    def nextToken: Optional[NextToken2500]
    def maxResults: Optional[MaxResult100]
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getFilters
        : ZIO[Any, Nothing, List[zio.aws.connect.model.FilterV2.ReadOnly]] =
      ZIO.succeed(filters)
    def getGroupings: ZIO[Any, AwsError, List[GroupingV2]] =
      AwsError.unwrapOptionField("groupings", groupings)
    def getMetrics
        : ZIO[Any, Nothing, List[zio.aws.connect.model.MetricV2.ReadOnly]] =
      ZIO.succeed(metrics)
    def getNextToken: ZIO[Any, AwsError, NextToken2500] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetMetricDataV2Request
  ) extends zio.aws.connect.model.GetMetricDataV2Request.ReadOnly {
    override val resourceArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.resourceArn())
    override val startTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.endTime())
    override val filters: List[zio.aws.connect.model.FilterV2.ReadOnly] = impl
      .filters()
      .asScala
      .map { item =>
        zio.aws.connect.model.FilterV2.wrap(item)
      }
      .toList
    override val groupings: Optional[List[GroupingV2]] = zio.aws.core.internal
      .optionalFromNullable(impl.groupings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.primitives.GroupingV2(item)
        }.toList
      )
    override val metrics: List[zio.aws.connect.model.MetricV2.ReadOnly] = impl
      .metrics()
      .asScala
      .map { item =>
        zio.aws.connect.model.MetricV2.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken2500] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken2500(value))
    override val maxResults: Optional[MaxResult100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetMetricDataV2Request
  ): zio.aws.connect.model.GetMetricDataV2Request.ReadOnly = new Wrapper(impl)
}
