package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken2500
import scala.jdk.CollectionConverters._
final case class GetMetricDataV2Response(
    nextToken: Optional[NextToken2500] = Optional.Absent,
    metricResults: Optional[Iterable[zio.aws.connect.model.MetricResultV2]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetMetricDataV2Response = {
    import GetMetricDataV2Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetMetricDataV2Response
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken2500.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        metricResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricResults)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.GetMetricDataV2Response.ReadOnly =
    zio.aws.connect.model.GetMetricDataV2Response.wrap(buildAwsValue())
}
object GetMetricDataV2Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetMetricDataV2Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetMetricDataV2Response =
      zio.aws.connect.model.GetMetricDataV2Response(
        nextToken.map(value => value),
        metricResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken2500]
    def metricResults
        : Optional[List[zio.aws.connect.model.MetricResultV2.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken2500] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMetricResults: ZIO[Any, AwsError, List[
      zio.aws.connect.model.MetricResultV2.ReadOnly
    ]] = AwsError.unwrapOptionField("metricResults", metricResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetMetricDataV2Response
  ) extends zio.aws.connect.model.GetMetricDataV2Response.ReadOnly {
    override val nextToken: Optional[NextToken2500] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken2500(value))
    override val metricResults
        : Optional[List[zio.aws.connect.model.MetricResultV2.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricResults())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.MetricResultV2.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetMetricDataV2Response
  ): zio.aws.connect.model.GetMetricDataV2Response.ReadOnly = new Wrapper(impl)
}
