package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{PromptId, InstanceId}
import scala.jdk.CollectionConverters._
final case class GetPromptFileRequest(
    instanceId: InstanceId,
    promptId: PromptId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetPromptFileRequest = {
    import GetPromptFileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetPromptFileRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .promptId(PromptId.unwrap(promptId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.GetPromptFileRequest.ReadOnly =
    zio.aws.connect.model.GetPromptFileRequest.wrap(buildAwsValue())
}
object GetPromptFileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetPromptFileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetPromptFileRequest =
      zio.aws.connect.model.GetPromptFileRequest(instanceId, promptId)
    def instanceId: InstanceId
    def promptId: PromptId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getPromptId: ZIO[Any, Nothing, PromptId] = ZIO.succeed(promptId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetPromptFileRequest
  ) extends zio.aws.connect.model.GetPromptFileRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val promptId: PromptId =
      zio.aws.connect.model.primitives.PromptId(impl.promptId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetPromptFileRequest
  ): zio.aws.connect.model.GetPromptFileRequest.ReadOnly = new Wrapper(impl)
}
