package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.PromptPresignedUrl
import scala.jdk.CollectionConverters._
final case class GetPromptFileResponse(
    promptPresignedUrl: Optional[PromptPresignedUrl] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetPromptFileResponse = {
    import GetPromptFileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetPromptFileResponse
      .builder()
      .optionallyWith(
        promptPresignedUrl.map(value =>
          PromptPresignedUrl.unwrap(value): java.lang.String
        )
      )(_.promptPresignedUrl)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.GetPromptFileResponse.ReadOnly =
    zio.aws.connect.model.GetPromptFileResponse.wrap(buildAwsValue())
}
object GetPromptFileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetPromptFileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetPromptFileResponse =
      zio.aws.connect.model
        .GetPromptFileResponse(promptPresignedUrl.map(value => value))
    def promptPresignedUrl: Optional[PromptPresignedUrl]
    def getPromptPresignedUrl: ZIO[Any, AwsError, PromptPresignedUrl] =
      AwsError.unwrapOptionField("promptPresignedUrl", promptPresignedUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetPromptFileResponse
  ) extends zio.aws.connect.model.GetPromptFileResponse.ReadOnly {
    override val promptPresignedUrl: Optional[PromptPresignedUrl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.promptPresignedUrl())
        .map(value =>
          zio.aws.connect.model.primitives.PromptPresignedUrl(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetPromptFileResponse
  ): zio.aws.connect.model.GetPromptFileResponse.ReadOnly = new Wrapper(impl)
}
