package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  SnapshotVersion,
  TaskTemplateId,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class GetTaskTemplateRequest(
    instanceId: InstanceId,
    taskTemplateId: TaskTemplateId,
    snapshotVersion: Optional[SnapshotVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetTaskTemplateRequest = {
    import GetTaskTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetTaskTemplateRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .taskTemplateId(TaskTemplateId.unwrap(taskTemplateId): java.lang.String)
      .optionallyWith(
        snapshotVersion.map(value =>
          SnapshotVersion.unwrap(value): java.lang.String
        )
      )(_.snapshotVersion)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.GetTaskTemplateRequest.ReadOnly =
    zio.aws.connect.model.GetTaskTemplateRequest.wrap(buildAwsValue())
}
object GetTaskTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetTaskTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetTaskTemplateRequest =
      zio.aws.connect.model.GetTaskTemplateRequest(
        instanceId,
        taskTemplateId,
        snapshotVersion.map(value => value)
      )
    def instanceId: InstanceId
    def taskTemplateId: TaskTemplateId
    def snapshotVersion: Optional[SnapshotVersion]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getTaskTemplateId: ZIO[Any, Nothing, TaskTemplateId] =
      ZIO.succeed(taskTemplateId)
    def getSnapshotVersion: ZIO[Any, AwsError, SnapshotVersion] =
      AwsError.unwrapOptionField("snapshotVersion", snapshotVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetTaskTemplateRequest
  ) extends zio.aws.connect.model.GetTaskTemplateRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val taskTemplateId: TaskTemplateId =
      zio.aws.connect.model.primitives.TaskTemplateId(impl.taskTemplateId())
    override val snapshotVersion: Optional[SnapshotVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotVersion())
        .map(value => zio.aws.connect.model.primitives.SnapshotVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetTaskTemplateRequest
  ): zio.aws.connect.model.GetTaskTemplateRequest.ReadOnly = new Wrapper(impl)
}
