package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  TrafficDistributionGroupArn,
  TrafficDistributionGroupId
}
import scala.jdk.CollectionConverters._
final case class GetTrafficDistributionResponse(
    telephonyConfig: Optional[zio.aws.connect.model.TelephonyConfig] =
      Optional.Absent,
    id: Optional[TrafficDistributionGroupId] = Optional.Absent,
    arn: Optional[TrafficDistributionGroupArn] = Optional.Absent,
    signInConfig: Optional[zio.aws.connect.model.SignInConfig] =
      Optional.Absent,
    agentConfig: Optional[zio.aws.connect.model.AgentConfig] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.GetTrafficDistributionResponse = {
    import GetTrafficDistributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.GetTrafficDistributionResponse
      .builder()
      .optionallyWith(telephonyConfig.map(value => value.buildAwsValue()))(
        _.telephonyConfig
      )
      .optionallyWith(
        id.map(value =>
          TrafficDistributionGroupId.unwrap(value): java.lang.String
        )
      )(_.id)
      .optionallyWith(
        arn.map(value =>
          TrafficDistributionGroupArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .optionallyWith(signInConfig.map(value => value.buildAwsValue()))(
        _.signInConfig
      )
      .optionallyWith(agentConfig.map(value => value.buildAwsValue()))(
        _.agentConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.GetTrafficDistributionResponse.ReadOnly =
    zio.aws.connect.model.GetTrafficDistributionResponse.wrap(buildAwsValue())
}
object GetTrafficDistributionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.GetTrafficDistributionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.GetTrafficDistributionResponse =
      zio.aws.connect.model.GetTrafficDistributionResponse(
        telephonyConfig.map(value => value.asEditable),
        id.map(value => value),
        arn.map(value => value),
        signInConfig.map(value => value.asEditable),
        agentConfig.map(value => value.asEditable)
      )
    def telephonyConfig
        : Optional[zio.aws.connect.model.TelephonyConfig.ReadOnly]
    def id: Optional[TrafficDistributionGroupId]
    def arn: Optional[TrafficDistributionGroupArn]
    def signInConfig: Optional[zio.aws.connect.model.SignInConfig.ReadOnly]
    def agentConfig: Optional[zio.aws.connect.model.AgentConfig.ReadOnly]
    def getTelephonyConfig
        : ZIO[Any, AwsError, zio.aws.connect.model.TelephonyConfig.ReadOnly] =
      AwsError.unwrapOptionField("telephonyConfig", telephonyConfig)
    def getId: ZIO[Any, AwsError, TrafficDistributionGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, TrafficDistributionGroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getSignInConfig
        : ZIO[Any, AwsError, zio.aws.connect.model.SignInConfig.ReadOnly] =
      AwsError.unwrapOptionField("signInConfig", signInConfig)
    def getAgentConfig
        : ZIO[Any, AwsError, zio.aws.connect.model.AgentConfig.ReadOnly] =
      AwsError.unwrapOptionField("agentConfig", agentConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.GetTrafficDistributionResponse
  ) extends zio.aws.connect.model.GetTrafficDistributionResponse.ReadOnly {
    override val telephonyConfig
        : Optional[zio.aws.connect.model.TelephonyConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.telephonyConfig())
        .map(value => zio.aws.connect.model.TelephonyConfig.wrap(value))
    override val id: Optional[TrafficDistributionGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.connect.model.primitives.TrafficDistributionGroupId(value)
        )
    override val arn: Optional[TrafficDistributionGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.connect.model.primitives.TrafficDistributionGroupArn(value)
        )
    override val signInConfig
        : Optional[zio.aws.connect.model.SignInConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signInConfig())
        .map(value => zio.aws.connect.model.SignInConfig.wrap(value))
    override val agentConfig
        : Optional[zio.aws.connect.model.AgentConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.agentConfig())
        .map(value => zio.aws.connect.model.AgentConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.GetTrafficDistributionResponse
  ): zio.aws.connect.model.GetTrafficDistributionResponse.ReadOnly =
    new Wrapper(impl)
}
