package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait Grouping {
  def unwrap: software.amazon.awssdk.services.connect.model.Grouping
}
object Grouping {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.Grouping
  ): zio.aws.connect.model.Grouping = value match {
    case software.amazon.awssdk.services.connect.model.Grouping.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.Grouping.QUEUE =>
      val r = QUEUE
      r
    case software.amazon.awssdk.services.connect.model.Grouping.CHANNEL =>
      val r = CHANNEL
      r
    case software.amazon.awssdk.services.connect.model.Grouping.ROUTING_PROFILE =>
      val r = ROUTING_PROFILE
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.Grouping {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.Grouping =
      software.amazon.awssdk.services.connect.model.Grouping.UNKNOWN_TO_SDK_VERSION
  }
  case object QUEUE extends zio.aws.connect.model.Grouping {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.Grouping =
      software.amazon.awssdk.services.connect.model.Grouping.QUEUE
  }
  case object CHANNEL extends zio.aws.connect.model.Grouping {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.Grouping =
      software.amazon.awssdk.services.connect.model.Grouping.CHANNEL
  }
  case object ROUTING_PROFILE extends zio.aws.connect.model.Grouping {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.Grouping =
      software.amazon.awssdk.services.connect.model.Grouping.ROUTING_PROFILE
  }
}
