package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  TagValue,
  HierarchyLevelId,
  HierarchyGroupId,
  HierarchyGroupName,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class HierarchyGroup(
    id: Optional[HierarchyGroupId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    name: Optional[HierarchyGroupName] = Optional.Absent,
    levelId: Optional[HierarchyLevelId] = Optional.Absent,
    hierarchyPath: Optional[zio.aws.connect.model.HierarchyPath] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HierarchyGroup = {
    import HierarchyGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HierarchyGroup
      .builder()
      .optionallyWith(
        id.map(value => HierarchyGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => HierarchyGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        levelId.map(value => HierarchyLevelId.unwrap(value): java.lang.String)
      )(_.levelId)
      .optionallyWith(hierarchyPath.map(value => value.buildAwsValue()))(
        _.hierarchyPath
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HierarchyGroup.ReadOnly =
    zio.aws.connect.model.HierarchyGroup.wrap(buildAwsValue())
}
object HierarchyGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HierarchyGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HierarchyGroup =
      zio.aws.connect.model.HierarchyGroup(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        levelId.map(value => value),
        hierarchyPath.map(value => value.asEditable),
        tags.map(value => value)
      )
    def id: Optional[HierarchyGroupId]
    def arn: Optional[ARN]
    def name: Optional[HierarchyGroupName]
    def levelId: Optional[HierarchyLevelId]
    def hierarchyPath: Optional[zio.aws.connect.model.HierarchyPath.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getId: ZIO[Any, AwsError, HierarchyGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, HierarchyGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getLevelId: ZIO[Any, AwsError, HierarchyLevelId] =
      AwsError.unwrapOptionField("levelId", levelId)
    def getHierarchyPath
        : ZIO[Any, AwsError, zio.aws.connect.model.HierarchyPath.ReadOnly] =
      AwsError.unwrapOptionField("hierarchyPath", hierarchyPath)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HierarchyGroup
  ) extends zio.aws.connect.model.HierarchyGroup.ReadOnly {
    override val id: Optional[HierarchyGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.HierarchyGroupId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Optional[HierarchyGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.HierarchyGroupName(value))
    override val levelId: Optional[HierarchyLevelId] = zio.aws.core.internal
      .optionalFromNullable(impl.levelId())
      .map(value => zio.aws.connect.model.primitives.HierarchyLevelId(value))
    override val hierarchyPath
        : Optional[zio.aws.connect.model.HierarchyPath.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hierarchyPath())
        .map(value => zio.aws.connect.model.HierarchyPath.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HierarchyGroup
  ): zio.aws.connect.model.HierarchyGroup.ReadOnly = new Wrapper(impl)
}
