package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.HierarchyLevelName
import scala.jdk.CollectionConverters._
final case class HierarchyLevelUpdate(name: HierarchyLevelName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HierarchyLevelUpdate = {
    import HierarchyLevelUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HierarchyLevelUpdate
      .builder()
      .name(HierarchyLevelName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HierarchyLevelUpdate.ReadOnly =
    zio.aws.connect.model.HierarchyLevelUpdate.wrap(buildAwsValue())
}
object HierarchyLevelUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HierarchyLevelUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HierarchyLevelUpdate =
      zio.aws.connect.model.HierarchyLevelUpdate(name)
    def name: HierarchyLevelName
    def getName: ZIO[Any, Nothing, HierarchyLevelName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HierarchyLevelUpdate
  ) extends zio.aws.connect.model.HierarchyLevelUpdate.ReadOnly {
    override val name: HierarchyLevelName =
      zio.aws.connect.model.primitives.HierarchyLevelName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HierarchyLevelUpdate
  ): zio.aws.connect.model.HierarchyLevelUpdate.ReadOnly = new Wrapper(impl)
}
