package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait HistoricalMetricName {
  def unwrap: software.amazon.awssdk.services.connect.model.HistoricalMetricName
}
object HistoricalMetricName {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.HistoricalMetricName
  ): zio.aws.connect.model.HistoricalMetricName = value match {
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_QUEUED =>
      val r = CONTACTS_QUEUED
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_HANDLED =>
      val r = CONTACTS_HANDLED
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_ABANDONED =>
      val r = CONTACTS_ABANDONED
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_CONSULTED =>
      val r = CONTACTS_CONSULTED
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_AGENT_HUNG_UP_FIRST =>
      val r = CONTACTS_AGENT_HUNG_UP_FIRST
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_HANDLED_INCOMING =>
      val r = CONTACTS_HANDLED_INCOMING
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_HANDLED_OUTBOUND =>
      val r = CONTACTS_HANDLED_OUTBOUND
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_HOLD_ABANDONS =>
      val r = CONTACTS_HOLD_ABANDONS
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_TRANSFERRED_IN =>
      val r = CONTACTS_TRANSFERRED_IN
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_TRANSFERRED_OUT =>
      val r = CONTACTS_TRANSFERRED_OUT
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_TRANSFERRED_IN_FROM_QUEUE =>
      val r = CONTACTS_TRANSFERRED_IN_FROM_QUEUE
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_TRANSFERRED_OUT_FROM_QUEUE =>
      val r = CONTACTS_TRANSFERRED_OUT_FROM_QUEUE
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_MISSED =>
      val r = CONTACTS_MISSED
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.CALLBACK_CONTACTS_HANDLED =>
      val r = CALLBACK_CONTACTS_HANDLED
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.API_CONTACTS_HANDLED =>
      val r = API_CONTACTS_HANDLED
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.OCCUPANCY =>
      val r = OCCUPANCY
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.HANDLE_TIME =>
      val r = HANDLE_TIME
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.AFTER_CONTACT_WORK_TIME =>
      val r = AFTER_CONTACT_WORK_TIME
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.QUEUED_TIME =>
      val r = QUEUED_TIME
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.ABANDON_TIME =>
      val r = ABANDON_TIME
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.QUEUE_ANSWER_TIME =>
      val r = QUEUE_ANSWER_TIME
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.HOLD_TIME =>
      val r = HOLD_TIME
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.INTERACTION_TIME =>
      val r = INTERACTION_TIME
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.INTERACTION_AND_HOLD_TIME =>
      val r = INTERACTION_AND_HOLD_TIME
      r
    case software.amazon.awssdk.services.connect.model.HistoricalMetricName.SERVICE_LEVEL =>
      val r = SERVICE_LEVEL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.UNKNOWN_TO_SDK_VERSION
  }
  case object CONTACTS_QUEUED
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_QUEUED
  }
  case object CONTACTS_HANDLED
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_HANDLED
  }
  case object CONTACTS_ABANDONED
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_ABANDONED
  }
  case object CONTACTS_CONSULTED
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_CONSULTED
  }
  case object CONTACTS_AGENT_HUNG_UP_FIRST
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_AGENT_HUNG_UP_FIRST
  }
  case object CONTACTS_HANDLED_INCOMING
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_HANDLED_INCOMING
  }
  case object CONTACTS_HANDLED_OUTBOUND
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_HANDLED_OUTBOUND
  }
  case object CONTACTS_HOLD_ABANDONS
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_HOLD_ABANDONS
  }
  case object CONTACTS_TRANSFERRED_IN
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_TRANSFERRED_IN
  }
  case object CONTACTS_TRANSFERRED_OUT
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_TRANSFERRED_OUT
  }
  case object CONTACTS_TRANSFERRED_IN_FROM_QUEUE
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_TRANSFERRED_IN_FROM_QUEUE
  }
  case object CONTACTS_TRANSFERRED_OUT_FROM_QUEUE
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_TRANSFERRED_OUT_FROM_QUEUE
  }
  case object CONTACTS_MISSED
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.CONTACTS_MISSED
  }
  case object CALLBACK_CONTACTS_HANDLED
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.CALLBACK_CONTACTS_HANDLED
  }
  case object API_CONTACTS_HANDLED
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.API_CONTACTS_HANDLED
  }
  case object OCCUPANCY extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.OCCUPANCY
  }
  case object HANDLE_TIME extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.HANDLE_TIME
  }
  case object AFTER_CONTACT_WORK_TIME
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.AFTER_CONTACT_WORK_TIME
  }
  case object QUEUED_TIME extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.QUEUED_TIME
  }
  case object ABANDON_TIME extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.ABANDON_TIME
  }
  case object QUEUE_ANSWER_TIME
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.QUEUE_ANSWER_TIME
  }
  case object HOLD_TIME extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.HOLD_TIME
  }
  case object INTERACTION_TIME
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.INTERACTION_TIME
  }
  case object INTERACTION_AND_HOLD_TIME
      extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.INTERACTION_AND_HOLD_TIME
  }
  case object SERVICE_LEVEL extends zio.aws.connect.model.HistoricalMetricName {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.HistoricalMetricName =
      software.amazon.awssdk.services.connect.model.HistoricalMetricName.SERVICE_LEVEL
  }
}
