package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  HoursOfOperationDescription,
  HoursOfOperationId,
  TagValue,
  TimeZone,
  CommonNameLength127,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class HoursOfOperation(
    hoursOfOperationId: Optional[HoursOfOperationId] = Optional.Absent,
    hoursOfOperationArn: Optional[ARN] = Optional.Absent,
    name: Optional[CommonNameLength127] = Optional.Absent,
    description: Optional[HoursOfOperationDescription] = Optional.Absent,
    timeZone: Optional[TimeZone] = Optional.Absent,
    config: Optional[Iterable[zio.aws.connect.model.HoursOfOperationConfig]] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HoursOfOperation = {
    import HoursOfOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HoursOfOperation
      .builder()
      .optionallyWith(
        hoursOfOperationId.map(value =>
          HoursOfOperationId.unwrap(value): java.lang.String
        )
      )(_.hoursOfOperationId)
      .optionallyWith(
        hoursOfOperationArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.hoursOfOperationArn)
      .optionallyWith(
        name.map(value => CommonNameLength127.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          HoursOfOperationDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        timeZone.map(value => TimeZone.unwrap(value): java.lang.String)
      )(_.timeZone)
      .optionallyWith(
        config.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.config)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HoursOfOperation.ReadOnly =
    zio.aws.connect.model.HoursOfOperation.wrap(buildAwsValue())
}
object HoursOfOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HoursOfOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HoursOfOperation =
      zio.aws.connect.model.HoursOfOperation(
        hoursOfOperationId.map(value => value),
        hoursOfOperationArn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        timeZone.map(value => value),
        config.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value)
      )
    def hoursOfOperationId: Optional[HoursOfOperationId]
    def hoursOfOperationArn: Optional[ARN]
    def name: Optional[CommonNameLength127]
    def description: Optional[HoursOfOperationDescription]
    def timeZone: Optional[TimeZone]
    def config
        : Optional[List[zio.aws.connect.model.HoursOfOperationConfig.ReadOnly]]
    def tags: Optional[Map[TagKey, TagValue]]
    def getHoursOfOperationId: ZIO[Any, AwsError, HoursOfOperationId] =
      AwsError.unwrapOptionField("hoursOfOperationId", hoursOfOperationId)
    def getHoursOfOperationArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("hoursOfOperationArn", hoursOfOperationArn)
    def getName: ZIO[Any, AwsError, CommonNameLength127] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, HoursOfOperationDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTimeZone: ZIO[Any, AwsError, TimeZone] =
      AwsError.unwrapOptionField("timeZone", timeZone)
    def getConfig: ZIO[Any, AwsError, List[
      zio.aws.connect.model.HoursOfOperationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("config", config)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HoursOfOperation
  ) extends zio.aws.connect.model.HoursOfOperation.ReadOnly {
    override val hoursOfOperationId: Optional[HoursOfOperationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hoursOfOperationId())
        .map(value =>
          zio.aws.connect.model.primitives.HoursOfOperationId(value)
        )
    override val hoursOfOperationArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.hoursOfOperationArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Optional[CommonNameLength127] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.CommonNameLength127(value))
    override val description: Optional[HoursOfOperationDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.HoursOfOperationDescription(value)
        )
    override val timeZone: Optional[TimeZone] = zio.aws.core.internal
      .optionalFromNullable(impl.timeZone())
      .map(value => zio.aws.connect.model.primitives.TimeZone(value))
    override val config: Optional[
      List[zio.aws.connect.model.HoursOfOperationConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.config())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.HoursOfOperationConfig.wrap(item)
        }.toList
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HoursOfOperation
  ): zio.aws.connect.model.HoursOfOperation.ReadOnly = new Wrapper(impl)
}
