package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HoursOfOperationSearchFilter(
    tagFilter: Optional[zio.aws.connect.model.ControlPlaneTagFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.HoursOfOperationSearchFilter = {
    import HoursOfOperationSearchFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.HoursOfOperationSearchFilter
      .builder()
      .optionallyWith(tagFilter.map(value => value.buildAwsValue()))(
        _.tagFilter
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.HoursOfOperationSearchFilter.ReadOnly =
    zio.aws.connect.model.HoursOfOperationSearchFilter.wrap(buildAwsValue())
}
object HoursOfOperationSearchFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.HoursOfOperationSearchFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.HoursOfOperationSearchFilter =
      zio.aws.connect.model
        .HoursOfOperationSearchFilter(tagFilter.map(value => value.asEditable))
    def tagFilter
        : Optional[zio.aws.connect.model.ControlPlaneTagFilter.ReadOnly]
    def getTagFilter: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.ControlPlaneTagFilter.ReadOnly
    ] = AwsError.unwrapOptionField("tagFilter", tagFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.HoursOfOperationSearchFilter
  ) extends zio.aws.connect.model.HoursOfOperationSearchFilter.ReadOnly {
    override val tagFilter
        : Optional[zio.aws.connect.model.ControlPlaneTagFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagFilter())
        .map(value => zio.aws.connect.model.ControlPlaneTagFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.HoursOfOperationSearchFilter
  ): zio.aws.connect.model.HoursOfOperationSearchFilter.ReadOnly = new Wrapper(
    impl
  )
}
