package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  DirectoryAlias,
  Url,
  InstanceId,
  Timestamp,
  InboundCallsEnabled,
  OutboundCallsEnabled,
  ARN
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Instance(
    id: Optional[InstanceId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    identityManagementType: Optional[zio.aws.connect.model.DirectoryType] =
      Optional.Absent,
    instanceAlias: Optional[DirectoryAlias] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    serviceRole: Optional[ARN] = Optional.Absent,
    instanceStatus: Optional[zio.aws.connect.model.InstanceStatus] =
      Optional.Absent,
    statusReason: Optional[zio.aws.connect.model.InstanceStatusReason] =
      Optional.Absent,
    inboundCallsEnabled: Optional[InboundCallsEnabled] = Optional.Absent,
    outboundCallsEnabled: Optional[OutboundCallsEnabled] = Optional.Absent,
    instanceAccessUrl: Optional[Url] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.Instance = {
    import Instance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.Instance
      .builder()
      .optionallyWith(
        id.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(identityManagementType.map(value => value.unwrap))(
        _.identityManagementType
      )
      .optionallyWith(
        instanceAlias.map(value =>
          DirectoryAlias.unwrap(value): java.lang.String
        )
      )(_.instanceAlias)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        serviceRole.map(value => ARN.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(instanceStatus.map(value => value.unwrap))(
        _.instanceStatus
      )
      .optionallyWith(statusReason.map(value => value.buildAwsValue()))(
        _.statusReason
      )
      .optionallyWith(
        inboundCallsEnabled.map(value =>
          InboundCallsEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.inboundCallsEnabled)
      .optionallyWith(
        outboundCallsEnabled.map(value =>
          OutboundCallsEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.outboundCallsEnabled)
      .optionallyWith(
        instanceAccessUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.instanceAccessUrl)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.Instance.ReadOnly =
    zio.aws.connect.model.Instance.wrap(buildAwsValue())
}
object Instance {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.Instance] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.Instance =
      zio.aws.connect.model.Instance(
        id.map(value => value),
        arn.map(value => value),
        identityManagementType.map(value => value),
        instanceAlias.map(value => value),
        createdTime.map(value => value),
        serviceRole.map(value => value),
        instanceStatus.map(value => value),
        statusReason.map(value => value.asEditable),
        inboundCallsEnabled.map(value => value),
        outboundCallsEnabled.map(value => value),
        instanceAccessUrl.map(value => value)
      )
    def id: Optional[InstanceId]
    def arn: Optional[ARN]
    def identityManagementType: Optional[zio.aws.connect.model.DirectoryType]
    def instanceAlias: Optional[DirectoryAlias]
    def createdTime: Optional[Timestamp]
    def serviceRole: Optional[ARN]
    def instanceStatus: Optional[zio.aws.connect.model.InstanceStatus]
    def statusReason
        : Optional[zio.aws.connect.model.InstanceStatusReason.ReadOnly]
    def inboundCallsEnabled: Optional[InboundCallsEnabled]
    def outboundCallsEnabled: Optional[OutboundCallsEnabled]
    def instanceAccessUrl: Optional[Url]
    def getId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getIdentityManagementType
        : ZIO[Any, AwsError, zio.aws.connect.model.DirectoryType] = AwsError
      .unwrapOptionField("identityManagementType", identityManagementType)
    def getInstanceAlias: ZIO[Any, AwsError, DirectoryAlias] =
      AwsError.unwrapOptionField("instanceAlias", instanceAlias)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getServiceRole: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getInstanceStatus
        : ZIO[Any, AwsError, zio.aws.connect.model.InstanceStatus] =
      AwsError.unwrapOptionField("instanceStatus", instanceStatus)
    def getStatusReason: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.InstanceStatusReason.ReadOnly
    ] = AwsError.unwrapOptionField("statusReason", statusReason)
    def getInboundCallsEnabled: ZIO[Any, AwsError, InboundCallsEnabled] =
      AwsError.unwrapOptionField("inboundCallsEnabled", inboundCallsEnabled)
    def getOutboundCallsEnabled: ZIO[Any, AwsError, OutboundCallsEnabled] =
      AwsError.unwrapOptionField("outboundCallsEnabled", outboundCallsEnabled)
    def getInstanceAccessUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("instanceAccessUrl", instanceAccessUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.Instance
  ) extends zio.aws.connect.model.Instance.ReadOnly {
    override val id: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.InstanceId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val identityManagementType
        : Optional[zio.aws.connect.model.DirectoryType] = zio.aws.core.internal
      .optionalFromNullable(impl.identityManagementType())
      .map(value => zio.aws.connect.model.DirectoryType.wrap(value))
    override val instanceAlias: Optional[DirectoryAlias] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceAlias())
      .map(value => zio.aws.connect.model.primitives.DirectoryAlias(value))
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val serviceRole: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val instanceStatus
        : Optional[zio.aws.connect.model.InstanceStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceStatus())
      .map(value => zio.aws.connect.model.InstanceStatus.wrap(value))
    override val statusReason
        : Optional[zio.aws.connect.model.InstanceStatusReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusReason())
        .map(value => zio.aws.connect.model.InstanceStatusReason.wrap(value))
    override val inboundCallsEnabled: Optional[InboundCallsEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inboundCallsEnabled())
        .map(value =>
          zio.aws.connect.model.primitives.InboundCallsEnabled(value)
        )
    override val outboundCallsEnabled: Optional[OutboundCallsEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outboundCallsEnabled())
        .map(value =>
          zio.aws.connect.model.primitives.OutboundCallsEnabled(value)
        )
    override val instanceAccessUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceAccessUrl())
      .map(value => zio.aws.connect.model.primitives.Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.Instance
  ): zio.aws.connect.model.Instance.ReadOnly = new Wrapper(impl)
}
