package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait InstanceStatus {
  def unwrap: software.amazon.awssdk.services.connect.model.InstanceStatus
}
object InstanceStatus {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.InstanceStatus
  ): zio.aws.connect.model.InstanceStatus = value match {
    case software.amazon.awssdk.services.connect.model.InstanceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.InstanceStatus.CREATION_IN_PROGRESS =>
      val r = CREATION_IN_PROGRESS
      r
    case software.amazon.awssdk.services.connect.model.InstanceStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.connect.model.InstanceStatus.CREATION_FAILED =>
      val r = CREATION_FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.InstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceStatus =
      software.amazon.awssdk.services.connect.model.InstanceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATION_IN_PROGRESS
      extends zio.aws.connect.model.InstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceStatus =
      software.amazon.awssdk.services.connect.model.InstanceStatus.CREATION_IN_PROGRESS
  }
  case object ACTIVE extends zio.aws.connect.model.InstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceStatus =
      software.amazon.awssdk.services.connect.model.InstanceStatus.ACTIVE
  }
  case object CREATION_FAILED extends zio.aws.connect.model.InstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.InstanceStatus =
      software.amazon.awssdk.services.connect.model.InstanceStatus.CREATION_FAILED
  }
}
