package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  SourceApplicationName,
  IntegrationAssociationId,
  InstanceId,
  URI,
  ARN
}
import scala.jdk.CollectionConverters._
final case class IntegrationAssociationSummary(
    integrationAssociationId: Optional[IntegrationAssociationId] =
      Optional.Absent,
    integrationAssociationArn: Optional[ARN] = Optional.Absent,
    instanceId: Optional[InstanceId] = Optional.Absent,
    integrationType: Optional[zio.aws.connect.model.IntegrationType] =
      Optional.Absent,
    integrationArn: Optional[ARN] = Optional.Absent,
    sourceApplicationUrl: Optional[URI] = Optional.Absent,
    sourceApplicationName: Optional[SourceApplicationName] = Optional.Absent,
    sourceType: Optional[zio.aws.connect.model.SourceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.IntegrationAssociationSummary = {
    import IntegrationAssociationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.IntegrationAssociationSummary
      .builder()
      .optionallyWith(
        integrationAssociationId.map(value =>
          IntegrationAssociationId.unwrap(value): java.lang.String
        )
      )(_.integrationAssociationId)
      .optionallyWith(
        integrationAssociationArn.map(value =>
          ARN.unwrap(value): java.lang.String
        )
      )(_.integrationAssociationArn)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(integrationType.map(value => value.unwrap))(
        _.integrationType
      )
      .optionallyWith(
        integrationArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.integrationArn)
      .optionallyWith(
        sourceApplicationUrl.map(value => URI.unwrap(value): java.lang.String)
      )(_.sourceApplicationUrl)
      .optionallyWith(
        sourceApplicationName.map(value =>
          SourceApplicationName.unwrap(value): java.lang.String
        )
      )(_.sourceApplicationName)
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.IntegrationAssociationSummary.ReadOnly =
    zio.aws.connect.model.IntegrationAssociationSummary.wrap(buildAwsValue())
}
object IntegrationAssociationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.IntegrationAssociationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.IntegrationAssociationSummary =
      zio.aws.connect.model.IntegrationAssociationSummary(
        integrationAssociationId.map(value => value),
        integrationAssociationArn.map(value => value),
        instanceId.map(value => value),
        integrationType.map(value => value),
        integrationArn.map(value => value),
        sourceApplicationUrl.map(value => value),
        sourceApplicationName.map(value => value),
        sourceType.map(value => value)
      )
    def integrationAssociationId: Optional[IntegrationAssociationId]
    def integrationAssociationArn: Optional[ARN]
    def instanceId: Optional[InstanceId]
    def integrationType: Optional[zio.aws.connect.model.IntegrationType]
    def integrationArn: Optional[ARN]
    def sourceApplicationUrl: Optional[URI]
    def sourceApplicationName: Optional[SourceApplicationName]
    def sourceType: Optional[zio.aws.connect.model.SourceType]
    def getIntegrationAssociationId
        : ZIO[Any, AwsError, IntegrationAssociationId] = AwsError
      .unwrapOptionField("integrationAssociationId", integrationAssociationId)
    def getIntegrationAssociationArn: ZIO[Any, AwsError, ARN] = AwsError
      .unwrapOptionField("integrationAssociationArn", integrationAssociationArn)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getIntegrationType
        : ZIO[Any, AwsError, zio.aws.connect.model.IntegrationType] =
      AwsError.unwrapOptionField("integrationType", integrationType)
    def getIntegrationArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("integrationArn", integrationArn)
    def getSourceApplicationUrl: ZIO[Any, AwsError, URI] =
      AwsError.unwrapOptionField("sourceApplicationUrl", sourceApplicationUrl)
    def getSourceApplicationName: ZIO[Any, AwsError, SourceApplicationName] =
      AwsError.unwrapOptionField("sourceApplicationName", sourceApplicationName)
    def getSourceType: ZIO[Any, AwsError, zio.aws.connect.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.IntegrationAssociationSummary
  ) extends zio.aws.connect.model.IntegrationAssociationSummary.ReadOnly {
    override val integrationAssociationId: Optional[IntegrationAssociationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.integrationAssociationId())
        .map(value =>
          zio.aws.connect.model.primitives.IntegrationAssociationId(value)
        )
    override val integrationAssociationArn: Optional[ARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.integrationAssociationArn())
        .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.connect.model.primitives.InstanceId(value))
    override val integrationType
        : Optional[zio.aws.connect.model.IntegrationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.integrationType())
        .map(value => zio.aws.connect.model.IntegrationType.wrap(value))
    override val integrationArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.integrationArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val sourceApplicationUrl: Optional[URI] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceApplicationUrl())
      .map(value => zio.aws.connect.model.primitives.URI(value))
    override val sourceApplicationName: Optional[SourceApplicationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceApplicationName())
        .map(value =>
          zio.aws.connect.model.primitives.SourceApplicationName(value)
        )
    override val sourceType: Optional[zio.aws.connect.model.SourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value => zio.aws.connect.model.SourceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.IntegrationAssociationSummary
  ): zio.aws.connect.model.IntegrationAssociationSummary.ReadOnly = new Wrapper(
    impl
  )
}
