package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{Hours, Prefix}
import scala.jdk.CollectionConverters._
final case class KinesisVideoStreamConfig(
    prefix: Prefix,
    retentionPeriodHours: Hours,
    encryptionConfig: zio.aws.connect.model.EncryptionConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.KinesisVideoStreamConfig = {
    import KinesisVideoStreamConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.KinesisVideoStreamConfig
      .builder()
      .prefix(Prefix.unwrap(prefix): java.lang.String)
      .retentionPeriodHours(Hours.unwrap(retentionPeriodHours): Integer)
      .encryptionConfig(encryptionConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.connect.model.KinesisVideoStreamConfig.ReadOnly =
    zio.aws.connect.model.KinesisVideoStreamConfig.wrap(buildAwsValue())
}
object KinesisVideoStreamConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.KinesisVideoStreamConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.KinesisVideoStreamConfig =
      zio.aws.connect.model.KinesisVideoStreamConfig(
        prefix,
        retentionPeriodHours,
        encryptionConfig.asEditable
      )
    def prefix: Prefix
    def retentionPeriodHours: Hours
    def encryptionConfig: zio.aws.connect.model.EncryptionConfig.ReadOnly
    def getPrefix: ZIO[Any, Nothing, Prefix] = ZIO.succeed(prefix)
    def getRetentionPeriodHours: ZIO[Any, Nothing, Hours] =
      ZIO.succeed(retentionPeriodHours)
    def getEncryptionConfig
        : ZIO[Any, Nothing, zio.aws.connect.model.EncryptionConfig.ReadOnly] =
      ZIO.succeed(encryptionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.KinesisVideoStreamConfig
  ) extends zio.aws.connect.model.KinesisVideoStreamConfig.ReadOnly {
    override val prefix: Prefix =
      zio.aws.connect.model.primitives.Prefix(impl.prefix())
    override val retentionPeriodHours: Hours =
      zio.aws.connect.model.primitives.Hours(impl.retentionPeriodHours())
    override val encryptionConfig
        : zio.aws.connect.model.EncryptionConfig.ReadOnly =
      zio.aws.connect.model.EncryptionConfig.wrap(impl.encryptionConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.KinesisVideoStreamConfig
  ): zio.aws.connect.model.KinesisVideoStreamConfig.ReadOnly = new Wrapper(impl)
}
