package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{LexRegion, BotName}
import scala.jdk.CollectionConverters._
final case class LexBot(name: BotName, lexRegion: LexRegion) {
  def buildAwsValue(): software.amazon.awssdk.services.connect.model.LexBot = {
    import LexBot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.LexBot
      .builder()
      .name(BotName.unwrap(name): java.lang.String)
      .lexRegion(LexRegion.unwrap(lexRegion): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.LexBot.ReadOnly =
    zio.aws.connect.model.LexBot.wrap(buildAwsValue())
}
object LexBot {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.LexBot] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.LexBot =
      zio.aws.connect.model.LexBot(name, lexRegion)
    def name: BotName
    def lexRegion: LexRegion
    def getName: ZIO[Any, Nothing, BotName] = ZIO.succeed(name)
    def getLexRegion: ZIO[Any, Nothing, LexRegion] = ZIO.succeed(lexRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.LexBot
  ) extends zio.aws.connect.model.LexBot.ReadOnly {
    override val name: BotName =
      zio.aws.connect.model.primitives.BotName(impl.name())
    override val lexRegion: LexRegion =
      zio.aws.connect.model.primitives.LexRegion(impl.lexRegion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.LexBot
  ): zio.aws.connect.model.LexBot.ReadOnly = new Wrapper(impl)
}
