package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait LexVersion {
  def unwrap: software.amazon.awssdk.services.connect.model.LexVersion
}
object LexVersion {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.LexVersion
  ): zio.aws.connect.model.LexVersion = value match {
    case software.amazon.awssdk.services.connect.model.LexVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.LexVersion.V1 =>
      val r = V1
      r
    case software.amazon.awssdk.services.connect.model.LexVersion.V2 =>
      val r = V2
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.LexVersion {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.LexVersion =
      software.amazon.awssdk.services.connect.model.LexVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object V1 extends zio.aws.connect.model.LexVersion {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.LexVersion =
      software.amazon.awssdk.services.connect.model.LexVersion.V1
  }
  case object V2 extends zio.aws.connect.model.LexVersion {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.LexVersion =
      software.amazon.awssdk.services.connect.model.LexVersion.V2
  }
}
