package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListAgentStatusesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    agentStatusSummaryList: Optional[
      Iterable[zio.aws.connect.model.AgentStatusSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListAgentStatusesResponse = {
    import ListAgentStatusesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListAgentStatusesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        agentStatusSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.agentStatusSummaryList)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListAgentStatusesResponse.ReadOnly =
    zio.aws.connect.model.ListAgentStatusesResponse.wrap(buildAwsValue())
}
object ListAgentStatusesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListAgentStatusesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListAgentStatusesResponse =
      zio.aws.connect.model.ListAgentStatusesResponse(
        nextToken.map(value => value),
        agentStatusSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def agentStatusSummaryList
        : Optional[List[zio.aws.connect.model.AgentStatusSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAgentStatusSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.AgentStatusSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "agentStatusSummaryList",
      agentStatusSummaryList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListAgentStatusesResponse
  ) extends zio.aws.connect.model.ListAgentStatusesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val agentStatusSummaryList
        : Optional[List[zio.aws.connect.model.AgentStatusSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.agentStatusSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.AgentStatusSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListAgentStatusesResponse
  ): zio.aws.connect.model.ListAgentStatusesResponse.ReadOnly = new Wrapper(
    impl
  )
}
