package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{NextToken, Origin}
import scala.jdk.CollectionConverters._
final case class ListApprovedOriginsResponse(
    origins: Optional[Iterable[Origin]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListApprovedOriginsResponse = {
    import ListApprovedOriginsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListApprovedOriginsResponse
      .builder()
      .optionallyWith(
        origins.map(value =>
          value.map { item =>
            Origin.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.origins)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListApprovedOriginsResponse.ReadOnly =
    zio.aws.connect.model.ListApprovedOriginsResponse.wrap(buildAwsValue())
}
object ListApprovedOriginsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListApprovedOriginsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListApprovedOriginsResponse =
      zio.aws.connect.model.ListApprovedOriginsResponse(
        origins.map(value => value),
        nextToken.map(value => value)
      )
    def origins: Optional[List[Origin]]
    def nextToken: Optional[NextToken]
    def getOrigins: ZIO[Any, AwsError, List[Origin]] =
      AwsError.unwrapOptionField("origins", origins)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListApprovedOriginsResponse
  ) extends zio.aws.connect.model.ListApprovedOriginsResponse.ReadOnly {
    override val origins: Optional[List[Origin]] = zio.aws.core.internal
      .optionalFromNullable(impl.origins())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.primitives.Origin(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListApprovedOriginsResponse
  ): zio.aws.connect.model.ListApprovedOriginsResponse.ReadOnly = new Wrapper(
    impl
  )
}
