package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{NextToken, ContactId, InstanceId}
import scala.jdk.CollectionConverters._
final case class ListContactEvaluationsRequest(
    instanceId: InstanceId,
    contactId: ContactId,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListContactEvaluationsRequest = {
    import ListContactEvaluationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListContactEvaluationsRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactId(ContactId.unwrap(contactId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListContactEvaluationsRequest.ReadOnly =
    zio.aws.connect.model.ListContactEvaluationsRequest.wrap(buildAwsValue())
}
object ListContactEvaluationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListContactEvaluationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListContactEvaluationsRequest =
      zio.aws.connect.model.ListContactEvaluationsRequest(
        instanceId,
        contactId,
        nextToken.map(value => value)
      )
    def instanceId: InstanceId
    def contactId: ContactId
    def nextToken: Optional[NextToken]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactId: ZIO[Any, Nothing, ContactId] = ZIO.succeed(contactId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListContactEvaluationsRequest
  ) extends zio.aws.connect.model.ListContactEvaluationsRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.contactId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListContactEvaluationsRequest
  ): zio.aws.connect.model.ListContactEvaluationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
