package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListContactEvaluationsResponse(
    evaluationSummaryList: Iterable[zio.aws.connect.model.EvaluationSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListContactEvaluationsResponse = {
    import ListContactEvaluationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListContactEvaluationsResponse
      .builder()
      .evaluationSummaryList(evaluationSummaryList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListContactEvaluationsResponse.ReadOnly =
    zio.aws.connect.model.ListContactEvaluationsResponse.wrap(buildAwsValue())
}
object ListContactEvaluationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListContactEvaluationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListContactEvaluationsResponse =
      zio.aws.connect.model.ListContactEvaluationsResponse(
        evaluationSummaryList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def evaluationSummaryList
        : List[zio.aws.connect.model.EvaluationSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getEvaluationSummaryList: ZIO[Any, Nothing, List[
      zio.aws.connect.model.EvaluationSummary.ReadOnly
    ]] = ZIO.succeed(evaluationSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListContactEvaluationsResponse
  ) extends zio.aws.connect.model.ListContactEvaluationsResponse.ReadOnly {
    override val evaluationSummaryList
        : List[zio.aws.connect.model.EvaluationSummary.ReadOnly] = impl
      .evaluationSummaryList()
      .asScala
      .map { item =>
        zio.aws.connect.model.EvaluationSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListContactEvaluationsResponse
  ): zio.aws.connect.model.ListContactEvaluationsResponse.ReadOnly =
    new Wrapper(impl)
}
