package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  VocabularyNextToken,
  MaxResult100,
  InstanceId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDefaultVocabulariesRequest(
    instanceId: InstanceId,
    languageCode: Optional[zio.aws.connect.model.VocabularyLanguageCode] =
      Optional.Absent,
    maxResults: Optional[MaxResult100] = Optional.Absent,
    nextToken: Optional[VocabularyNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest = {
    import ListDefaultVocabulariesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        maxResults.map(value => MaxResult100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          VocabularyNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListDefaultVocabulariesRequest.ReadOnly =
    zio.aws.connect.model.ListDefaultVocabulariesRequest.wrap(buildAwsValue())
}
object ListDefaultVocabulariesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListDefaultVocabulariesRequest =
      zio.aws.connect.model.ListDefaultVocabulariesRequest(
        instanceId,
        languageCode.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def instanceId: InstanceId
    def languageCode: Optional[zio.aws.connect.model.VocabularyLanguageCode]
    def maxResults: Optional[MaxResult100]
    def nextToken: Optional[VocabularyNextToken]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.connect.model.VocabularyLanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getMaxResults: ZIO[Any, AwsError, MaxResult100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, VocabularyNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest
  ) extends zio.aws.connect.model.ListDefaultVocabulariesRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val languageCode
        : Optional[zio.aws.connect.model.VocabularyLanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.connect.model.VocabularyLanguageCode.wrap(value))
    override val maxResults: Optional[MaxResult100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult100(value))
    override val nextToken: Optional[VocabularyNextToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.connect.model.primitives.VocabularyNextToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest
  ): zio.aws.connect.model.ListDefaultVocabulariesRequest.ReadOnly =
    new Wrapper(impl)
}
