package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.VocabularyNextToken
import scala.jdk.CollectionConverters._
final case class ListDefaultVocabulariesResponse(
    defaultVocabularyList: Iterable[zio.aws.connect.model.DefaultVocabulary],
    nextToken: Optional[VocabularyNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesResponse = {
    import ListDefaultVocabulariesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesResponse
      .builder()
      .defaultVocabularyList(defaultVocabularyList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value =>
          VocabularyNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListDefaultVocabulariesResponse.ReadOnly =
    zio.aws.connect.model.ListDefaultVocabulariesResponse.wrap(buildAwsValue())
}
object ListDefaultVocabulariesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListDefaultVocabulariesResponse =
      zio.aws.connect.model.ListDefaultVocabulariesResponse(
        defaultVocabularyList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def defaultVocabularyList
        : List[zio.aws.connect.model.DefaultVocabulary.ReadOnly]
    def nextToken: Optional[VocabularyNextToken]
    def getDefaultVocabularyList: ZIO[Any, Nothing, List[
      zio.aws.connect.model.DefaultVocabulary.ReadOnly
    ]] = ZIO.succeed(defaultVocabularyList)
    def getNextToken: ZIO[Any, AwsError, VocabularyNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesResponse
  ) extends zio.aws.connect.model.ListDefaultVocabulariesResponse.ReadOnly {
    override val defaultVocabularyList
        : List[zio.aws.connect.model.DefaultVocabulary.ReadOnly] = impl
      .defaultVocabularyList()
      .asScala
      .map { item =>
        zio.aws.connect.model.DefaultVocabulary.wrap(item)
      }
      .toList
    override val nextToken: Optional[VocabularyNextToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.connect.model.primitives.VocabularyNextToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesResponse
  ): zio.aws.connect.model.ListDefaultVocabulariesResponse.ReadOnly =
    new Wrapper(impl)
}
