package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  NextToken,
  MaxResult100,
  ResourceId,
  InstanceId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListEvaluationFormVersionsRequest(
    instanceId: InstanceId,
    evaluationFormId: ResourceId,
    maxResults: Optional[MaxResult100] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsRequest = {
    import ListEvaluationFormVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .evaluationFormId(ResourceId.unwrap(evaluationFormId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResult100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListEvaluationFormVersionsRequest.ReadOnly =
    zio.aws.connect.model.ListEvaluationFormVersionsRequest
      .wrap(buildAwsValue())
}
object ListEvaluationFormVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListEvaluationFormVersionsRequest =
      zio.aws.connect.model.ListEvaluationFormVersionsRequest(
        instanceId,
        evaluationFormId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def instanceId: InstanceId
    def evaluationFormId: ResourceId
    def maxResults: Optional[MaxResult100]
    def nextToken: Optional[NextToken]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getEvaluationFormId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationFormId)
    def getMaxResults: ZIO[Any, AwsError, MaxResult100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsRequest
  ) extends zio.aws.connect.model.ListEvaluationFormVersionsRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val evaluationFormId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationFormId())
    override val maxResults: Optional[MaxResult100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult100(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsRequest
  ): zio.aws.connect.model.ListEvaluationFormVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
