package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListEvaluationFormVersionsResponse(
    evaluationFormVersionSummaryList: Iterable[
      zio.aws.connect.model.EvaluationFormVersionSummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsResponse = {
    import ListEvaluationFormVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsResponse
      .builder()
      .evaluationFormVersionSummaryList(evaluationFormVersionSummaryList.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListEvaluationFormVersionsResponse.ReadOnly =
    zio.aws.connect.model.ListEvaluationFormVersionsResponse
      .wrap(buildAwsValue())
}
object ListEvaluationFormVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListEvaluationFormVersionsResponse =
      zio.aws.connect.model.ListEvaluationFormVersionsResponse(
        evaluationFormVersionSummaryList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def evaluationFormVersionSummaryList
        : List[zio.aws.connect.model.EvaluationFormVersionSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getEvaluationFormVersionSummaryList: ZIO[Any, Nothing, List[
      zio.aws.connect.model.EvaluationFormVersionSummary.ReadOnly
    ]] = ZIO.succeed(evaluationFormVersionSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsResponse
  ) extends zio.aws.connect.model.ListEvaluationFormVersionsResponse.ReadOnly {
    override val evaluationFormVersionSummaryList
        : List[zio.aws.connect.model.EvaluationFormVersionSummary.ReadOnly] =
      impl
        .evaluationFormVersionSummaryList()
        .asScala
        .map { item =>
          zio.aws.connect.model.EvaluationFormVersionSummary.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsResponse
  ): zio.aws.connect.model.ListEvaluationFormVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
