package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListEvaluationFormsResponse(
    evaluationFormSummaryList: Iterable[
      zio.aws.connect.model.EvaluationFormSummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListEvaluationFormsResponse = {
    import ListEvaluationFormsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListEvaluationFormsResponse
      .builder()
      .evaluationFormSummaryList(evaluationFormSummaryList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListEvaluationFormsResponse.ReadOnly =
    zio.aws.connect.model.ListEvaluationFormsResponse.wrap(buildAwsValue())
}
object ListEvaluationFormsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListEvaluationFormsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListEvaluationFormsResponse =
      zio.aws.connect.model.ListEvaluationFormsResponse(
        evaluationFormSummaryList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def evaluationFormSummaryList
        : List[zio.aws.connect.model.EvaluationFormSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getEvaluationFormSummaryList: ZIO[Any, Nothing, List[
      zio.aws.connect.model.EvaluationFormSummary.ReadOnly
    ]] = ZIO.succeed(evaluationFormSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListEvaluationFormsResponse
  ) extends zio.aws.connect.model.ListEvaluationFormsResponse.ReadOnly {
    override val evaluationFormSummaryList
        : List[zio.aws.connect.model.EvaluationFormSummary.ReadOnly] = impl
      .evaluationFormSummaryList()
      .asScala
      .map { item =>
        zio.aws.connect.model.EvaluationFormSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListEvaluationFormsResponse
  ): zio.aws.connect.model.ListEvaluationFormsResponse.ReadOnly = new Wrapper(
    impl
  )
}
