package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListHoursOfOperationsResponse(
    hoursOfOperationSummaryList: Optional[
      Iterable[zio.aws.connect.model.HoursOfOperationSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListHoursOfOperationsResponse = {
    import ListHoursOfOperationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListHoursOfOperationsResponse
      .builder()
      .optionallyWith(
        hoursOfOperationSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hoursOfOperationSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListHoursOfOperationsResponse.ReadOnly =
    zio.aws.connect.model.ListHoursOfOperationsResponse.wrap(buildAwsValue())
}
object ListHoursOfOperationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListHoursOfOperationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListHoursOfOperationsResponse =
      zio.aws.connect.model.ListHoursOfOperationsResponse(
        hoursOfOperationSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def hoursOfOperationSummaryList
        : Optional[List[zio.aws.connect.model.HoursOfOperationSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getHoursOfOperationSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.HoursOfOperationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "hoursOfOperationSummaryList",
      hoursOfOperationSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListHoursOfOperationsResponse
  ) extends zio.aws.connect.model.ListHoursOfOperationsResponse.ReadOnly {
    override val hoursOfOperationSummaryList: Optional[
      List[zio.aws.connect.model.HoursOfOperationSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hoursOfOperationSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.HoursOfOperationSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListHoursOfOperationsResponse
  ): zio.aws.connect.model.ListHoursOfOperationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
