package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListInstanceStorageConfigsResponse(
    storageConfigs: Optional[
      Iterable[zio.aws.connect.model.InstanceStorageConfig]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsResponse = {
    import ListInstanceStorageConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsResponse
      .builder()
      .optionallyWith(
        storageConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageConfigs)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListInstanceStorageConfigsResponse.ReadOnly =
    zio.aws.connect.model.ListInstanceStorageConfigsResponse
      .wrap(buildAwsValue())
}
object ListInstanceStorageConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListInstanceStorageConfigsResponse =
      zio.aws.connect.model.ListInstanceStorageConfigsResponse(
        storageConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def storageConfigs
        : Optional[List[zio.aws.connect.model.InstanceStorageConfig.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getStorageConfigs: ZIO[Any, AwsError, List[
      zio.aws.connect.model.InstanceStorageConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("storageConfigs", storageConfigs)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsResponse
  ) extends zio.aws.connect.model.ListInstanceStorageConfigsResponse.ReadOnly {
    override val storageConfigs
        : Optional[List[zio.aws.connect.model.InstanceStorageConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageConfigs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.InstanceStorageConfig.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsResponse
  ): zio.aws.connect.model.ListInstanceStorageConfigsResponse.ReadOnly =
    new Wrapper(impl)
}
