package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListIntegrationAssociationsResponse(
    integrationAssociationSummaryList: Optional[
      Iterable[zio.aws.connect.model.IntegrationAssociationSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsResponse = {
    import ListIntegrationAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsResponse
      .builder()
      .optionallyWith(
        integrationAssociationSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.integrationAssociationSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListIntegrationAssociationsResponse.ReadOnly =
    zio.aws.connect.model.ListIntegrationAssociationsResponse
      .wrap(buildAwsValue())
}
object ListIntegrationAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListIntegrationAssociationsResponse =
      zio.aws.connect.model.ListIntegrationAssociationsResponse(
        integrationAssociationSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def integrationAssociationSummaryList: Optional[
      List[zio.aws.connect.model.IntegrationAssociationSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getIntegrationAssociationSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.IntegrationAssociationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "integrationAssociationSummaryList",
      integrationAssociationSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsResponse
  ) extends zio.aws.connect.model.ListIntegrationAssociationsResponse.ReadOnly {
    override val integrationAssociationSummaryList: Optional[
      List[zio.aws.connect.model.IntegrationAssociationSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.integrationAssociationSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.IntegrationAssociationSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsResponse
  ): zio.aws.connect.model.ListIntegrationAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
