package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListLexBotsResponse(
    lexBots: Optional[Iterable[zio.aws.connect.model.LexBot]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListLexBotsResponse = {
    import ListLexBotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListLexBotsResponse
      .builder()
      .optionallyWith(
        lexBots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lexBots)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListLexBotsResponse.ReadOnly =
    zio.aws.connect.model.ListLexBotsResponse.wrap(buildAwsValue())
}
object ListLexBotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListLexBotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListLexBotsResponse =
      zio.aws.connect.model.ListLexBotsResponse(
        lexBots.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def lexBots: Optional[List[zio.aws.connect.model.LexBot.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getLexBots
        : ZIO[Any, AwsError, List[zio.aws.connect.model.LexBot.ReadOnly]] =
      AwsError.unwrapOptionField("lexBots", lexBots)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListLexBotsResponse
  ) extends zio.aws.connect.model.ListLexBotsResponse.ReadOnly {
    override val lexBots
        : Optional[List[zio.aws.connect.model.LexBot.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lexBots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.LexBot.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListLexBotsResponse
  ): zio.aws.connect.model.ListLexBotsResponse.ReadOnly = new Wrapper(impl)
}
