package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListPhoneNumbersResponse(
    phoneNumberSummaryList: Optional[
      Iterable[zio.aws.connect.model.PhoneNumberSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListPhoneNumbersResponse = {
    import ListPhoneNumbersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListPhoneNumbersResponse
      .builder()
      .optionallyWith(
        phoneNumberSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phoneNumberSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListPhoneNumbersResponse.ReadOnly =
    zio.aws.connect.model.ListPhoneNumbersResponse.wrap(buildAwsValue())
}
object ListPhoneNumbersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListPhoneNumbersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListPhoneNumbersResponse =
      zio.aws.connect.model.ListPhoneNumbersResponse(
        phoneNumberSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def phoneNumberSummaryList
        : Optional[List[zio.aws.connect.model.PhoneNumberSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getPhoneNumberSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.PhoneNumberSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "phoneNumberSummaryList",
      phoneNumberSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListPhoneNumbersResponse
  ) extends zio.aws.connect.model.ListPhoneNumbersResponse.ReadOnly {
    override val phoneNumberSummaryList
        : Optional[List[zio.aws.connect.model.PhoneNumberSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.PhoneNumberSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListPhoneNumbersResponse
  ): zio.aws.connect.model.ListPhoneNumbersResponse.ReadOnly = new Wrapper(impl)
}
