package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  PhoneNumberPrefix,
  LargeNextToken,
  MaxResult1000,
  ARN
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPhoneNumbersV2Request(
    targetArn: Optional[ARN] = Optional.Absent,
    maxResults: Optional[MaxResult1000] = Optional.Absent,
    nextToken: Optional[LargeNextToken] = Optional.Absent,
    phoneNumberCountryCodes: Optional[
      Iterable[zio.aws.connect.model.PhoneNumberCountryCode]
    ] = Optional.Absent,
    phoneNumberTypes: Optional[
      Iterable[zio.aws.connect.model.PhoneNumberType]
    ] = Optional.Absent,
    phoneNumberPrefix: Optional[PhoneNumberPrefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request = {
    import ListPhoneNumbersV2Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request
      .builder()
      .optionallyWith(
        targetArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.targetArn)
      .optionallyWith(
        maxResults.map(value => MaxResult1000.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => LargeNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        phoneNumberCountryCodes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.phoneNumberCountryCodesWithStrings)
      .optionallyWith(
        phoneNumberTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.phoneNumberTypesWithStrings)
      .optionallyWith(
        phoneNumberPrefix.map(value =>
          PhoneNumberPrefix.unwrap(value): java.lang.String
        )
      )(_.phoneNumberPrefix)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListPhoneNumbersV2Request.ReadOnly =
    zio.aws.connect.model.ListPhoneNumbersV2Request.wrap(buildAwsValue())
}
object ListPhoneNumbersV2Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListPhoneNumbersV2Request =
      zio.aws.connect.model.ListPhoneNumbersV2Request(
        targetArn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        phoneNumberCountryCodes.map(value => value),
        phoneNumberTypes.map(value => value),
        phoneNumberPrefix.map(value => value)
      )
    def targetArn: Optional[ARN]
    def maxResults: Optional[MaxResult1000]
    def nextToken: Optional[LargeNextToken]
    def phoneNumberCountryCodes
        : Optional[List[zio.aws.connect.model.PhoneNumberCountryCode]]
    def phoneNumberTypes: Optional[List[zio.aws.connect.model.PhoneNumberType]]
    def phoneNumberPrefix: Optional[PhoneNumberPrefix]
    def getTargetArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("targetArn", targetArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResult1000] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, LargeNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPhoneNumberCountryCodes: ZIO[Any, AwsError, List[
      zio.aws.connect.model.PhoneNumberCountryCode
    ]] = AwsError.unwrapOptionField(
      "phoneNumberCountryCodes",
      phoneNumberCountryCodes
    )
    def getPhoneNumberTypes
        : ZIO[Any, AwsError, List[zio.aws.connect.model.PhoneNumberType]] =
      AwsError.unwrapOptionField("phoneNumberTypes", phoneNumberTypes)
    def getPhoneNumberPrefix: ZIO[Any, AwsError, PhoneNumberPrefix] =
      AwsError.unwrapOptionField("phoneNumberPrefix", phoneNumberPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request
  ) extends zio.aws.connect.model.ListPhoneNumbersV2Request.ReadOnly {
    override val targetArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.targetArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val maxResults: Optional[MaxResult1000] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult1000(value))
    override val nextToken: Optional[LargeNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.LargeNextToken(value))
    override val phoneNumberCountryCodes
        : Optional[List[zio.aws.connect.model.PhoneNumberCountryCode]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberCountryCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.PhoneNumberCountryCode.wrap(item)
          }.toList
        )
    override val phoneNumberTypes
        : Optional[List[zio.aws.connect.model.PhoneNumberType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.PhoneNumberType.wrap(item)
          }.toList
        )
    override val phoneNumberPrefix: Optional[PhoneNumberPrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberPrefix())
        .map(value => zio.aws.connect.model.primitives.PhoneNumberPrefix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request
  ): zio.aws.connect.model.ListPhoneNumbersV2Request.ReadOnly = new Wrapper(
    impl
  )
}
