package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.LargeNextToken
import scala.jdk.CollectionConverters._
final case class ListPhoneNumbersV2Response(
    nextToken: Optional[LargeNextToken] = Optional.Absent,
    listPhoneNumbersSummaryList: Optional[
      Iterable[zio.aws.connect.model.ListPhoneNumbersSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Response = {
    import ListPhoneNumbersV2Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Response
      .builder()
      .optionallyWith(
        nextToken.map(value => LargeNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        listPhoneNumbersSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.listPhoneNumbersSummaryList)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListPhoneNumbersV2Response.ReadOnly =
    zio.aws.connect.model.ListPhoneNumbersV2Response.wrap(buildAwsValue())
}
object ListPhoneNumbersV2Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListPhoneNumbersV2Response =
      zio.aws.connect.model.ListPhoneNumbersV2Response(
        nextToken.map(value => value),
        listPhoneNumbersSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[LargeNextToken]
    def listPhoneNumbersSummaryList
        : Optional[List[zio.aws.connect.model.ListPhoneNumbersSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, LargeNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getListPhoneNumbersSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.ListPhoneNumbersSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "listPhoneNumbersSummaryList",
      listPhoneNumbersSummaryList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Response
  ) extends zio.aws.connect.model.ListPhoneNumbersV2Response.ReadOnly {
    override val nextToken: Optional[LargeNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.LargeNextToken(value))
    override val listPhoneNumbersSummaryList: Optional[
      List[zio.aws.connect.model.ListPhoneNumbersSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listPhoneNumbersSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.ListPhoneNumbersSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Response
  ): zio.aws.connect.model.ListPhoneNumbersV2Response.ReadOnly = new Wrapper(
    impl
  )
}
