package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  MaxResult100,
  NextToken,
  QueueId,
  InstanceId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListQueueQuickConnectsRequest(
    instanceId: InstanceId,
    queueId: QueueId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResult100] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest = {
    import ListQueueQuickConnectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult100.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListQueueQuickConnectsRequest.ReadOnly =
    zio.aws.connect.model.ListQueueQuickConnectsRequest.wrap(buildAwsValue())
}
object ListQueueQuickConnectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListQueueQuickConnectsRequest =
      zio.aws.connect.model.ListQueueQuickConnectsRequest(
        instanceId,
        queueId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceId: InstanceId
    def queueId: QueueId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResult100]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest
  ) extends zio.aws.connect.model.ListQueueQuickConnectsRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val queueId: QueueId =
      zio.aws.connect.model.primitives.QueueId(impl.queueId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResult100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest
  ): zio.aws.connect.model.ListQueueQuickConnectsRequest.ReadOnly = new Wrapper(
    impl
  )
}
