package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListQueuesResponse(
    queueSummaryList: Optional[Iterable[zio.aws.connect.model.QueueSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListQueuesResponse = {
    import ListQueuesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListQueuesResponse
      .builder()
      .optionallyWith(
        queueSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queueSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListQueuesResponse.ReadOnly =
    zio.aws.connect.model.ListQueuesResponse.wrap(buildAwsValue())
}
object ListQueuesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListQueuesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListQueuesResponse =
      zio.aws.connect.model.ListQueuesResponse(
        queueSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def queueSummaryList
        : Optional[List[zio.aws.connect.model.QueueSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getQueueSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.QueueSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("queueSummaryList", queueSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListQueuesResponse
  ) extends zio.aws.connect.model.ListQueuesResponse.ReadOnly {
    override val queueSummaryList
        : Optional[List[zio.aws.connect.model.QueueSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queueSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.QueueSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListQueuesResponse
  ): zio.aws.connect.model.ListQueuesResponse.ReadOnly = new Wrapper(impl)
}
