package zio.aws.connect.model
import zio.aws.connect.model.primitives.{MaxResult1000, NextToken, InstanceId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListQuickConnectsRequest(
    instanceId: InstanceId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResult1000] = Optional.Absent,
    quickConnectTypes: Optional[
      Iterable[zio.aws.connect.model.QuickConnectType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest = {
    import ListQuickConnectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult1000.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        quickConnectTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.quickConnectTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListQuickConnectsRequest.ReadOnly =
    zio.aws.connect.model.ListQuickConnectsRequest.wrap(buildAwsValue())
}
object ListQuickConnectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListQuickConnectsRequest =
      zio.aws.connect.model.ListQuickConnectsRequest(
        instanceId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        quickConnectTypes.map(value => value)
      )
    def instanceId: InstanceId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResult1000]
    def quickConnectTypes
        : Optional[List[zio.aws.connect.model.QuickConnectType]]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult1000] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getQuickConnectTypes
        : ZIO[Any, AwsError, List[zio.aws.connect.model.QuickConnectType]] =
      AwsError.unwrapOptionField("quickConnectTypes", quickConnectTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest
  ) extends zio.aws.connect.model.ListQuickConnectsRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResult1000] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult1000(value))
    override val quickConnectTypes
        : Optional[List[zio.aws.connect.model.QuickConnectType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quickConnectTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.QuickConnectType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest
  ): zio.aws.connect.model.ListQuickConnectsRequest.ReadOnly = new Wrapper(impl)
}
