package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListQuickConnectsResponse(
    quickConnectSummaryList: Optional[
      Iterable[zio.aws.connect.model.QuickConnectSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListQuickConnectsResponse = {
    import ListQuickConnectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListQuickConnectsResponse
      .builder()
      .optionallyWith(
        quickConnectSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.quickConnectSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListQuickConnectsResponse.ReadOnly =
    zio.aws.connect.model.ListQuickConnectsResponse.wrap(buildAwsValue())
}
object ListQuickConnectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListQuickConnectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListQuickConnectsResponse =
      zio.aws.connect.model.ListQuickConnectsResponse(
        quickConnectSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def quickConnectSummaryList
        : Optional[List[zio.aws.connect.model.QuickConnectSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getQuickConnectSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.QuickConnectSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "quickConnectSummaryList",
      quickConnectSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListQuickConnectsResponse
  ) extends zio.aws.connect.model.ListQuickConnectsResponse.ReadOnly {
    override val quickConnectSummaryList
        : Optional[List[zio.aws.connect.model.QuickConnectSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quickConnectSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.QuickConnectSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListQuickConnectsResponse
  ): zio.aws.connect.model.ListQuickConnectsResponse.ReadOnly = new Wrapper(
    impl
  )
}
