package zio.aws.connect.model
import zio.aws.connect.model.primitives.{NextToken, MaxResult200, InstanceId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRulesRequest(
    instanceId: InstanceId,
    publishStatus: Optional[zio.aws.connect.model.RulePublishStatus] =
      Optional.Absent,
    eventSourceName: Optional[zio.aws.connect.model.EventSourceName] =
      Optional.Absent,
    maxResults: Optional[MaxResult200] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListRulesRequest = {
    import ListRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListRulesRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(publishStatus.map(value => value.unwrap))(_.publishStatus)
      .optionallyWith(eventSourceName.map(value => value.unwrap))(
        _.eventSourceName
      )
      .optionallyWith(
        maxResults.map(value => MaxResult200.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListRulesRequest.ReadOnly =
    zio.aws.connect.model.ListRulesRequest.wrap(buildAwsValue())
}
object ListRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListRulesRequest =
      zio.aws.connect.model.ListRulesRequest(
        instanceId,
        publishStatus.map(value => value),
        eventSourceName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def instanceId: InstanceId
    def publishStatus: Optional[zio.aws.connect.model.RulePublishStatus]
    def eventSourceName: Optional[zio.aws.connect.model.EventSourceName]
    def maxResults: Optional[MaxResult200]
    def nextToken: Optional[NextToken]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getPublishStatus
        : ZIO[Any, AwsError, zio.aws.connect.model.RulePublishStatus] =
      AwsError.unwrapOptionField("publishStatus", publishStatus)
    def getEventSourceName
        : ZIO[Any, AwsError, zio.aws.connect.model.EventSourceName] =
      AwsError.unwrapOptionField("eventSourceName", eventSourceName)
    def getMaxResults: ZIO[Any, AwsError, MaxResult200] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListRulesRequest
  ) extends zio.aws.connect.model.ListRulesRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val publishStatus
        : Optional[zio.aws.connect.model.RulePublishStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publishStatus())
        .map(value => zio.aws.connect.model.RulePublishStatus.wrap(value))
    override val eventSourceName
        : Optional[zio.aws.connect.model.EventSourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventSourceName())
        .map(value => zio.aws.connect.model.EventSourceName.wrap(value))
    override val maxResults: Optional[MaxResult200] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult200(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListRulesRequest
  ): zio.aws.connect.model.ListRulesRequest.ReadOnly = new Wrapper(impl)
}
