package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListRulesResponse(
    ruleSummaryList: Iterable[zio.aws.connect.model.RuleSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListRulesResponse = {
    import ListRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListRulesResponse
      .builder()
      .ruleSummaryList(ruleSummaryList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListRulesResponse.ReadOnly =
    zio.aws.connect.model.ListRulesResponse.wrap(buildAwsValue())
}
object ListRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListRulesResponse =
      zio.aws.connect.model.ListRulesResponse(
        ruleSummaryList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def ruleSummaryList: List[zio.aws.connect.model.RuleSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getRuleSummaryList
        : ZIO[Any, Nothing, List[zio.aws.connect.model.RuleSummary.ReadOnly]] =
      ZIO.succeed(ruleSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListRulesResponse
  ) extends zio.aws.connect.model.ListRulesResponse.ReadOnly {
    override val ruleSummaryList
        : List[zio.aws.connect.model.RuleSummary.ReadOnly] = impl
      .ruleSummaryList()
      .asScala
      .map { item =>
        zio.aws.connect.model.RuleSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListRulesResponse
  ): zio.aws.connect.model.ListRulesResponse.ReadOnly = new Wrapper(impl)
}
