package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{NextToken, SecurityProfilePermission}
import scala.jdk.CollectionConverters._
final case class ListSecurityProfilePermissionsResponse(
    permissions: Optional[Iterable[SecurityProfilePermission]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsResponse = {
    import ListSecurityProfilePermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsResponse
      .builder()
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            SecurityProfilePermission.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.permissions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListSecurityProfilePermissionsResponse.ReadOnly =
    zio.aws.connect.model.ListSecurityProfilePermissionsResponse
      .wrap(buildAwsValue())
}
object ListSecurityProfilePermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.ListSecurityProfilePermissionsResponse =
      zio.aws.connect.model.ListSecurityProfilePermissionsResponse(
        permissions.map(value => value),
        nextToken.map(value => value)
      )
    def permissions: Optional[List[SecurityProfilePermission]]
    def nextToken: Optional[NextToken]
    def getPermissions: ZIO[Any, AwsError, List[SecurityProfilePermission]] =
      AwsError.unwrapOptionField("permissions", permissions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsResponse
  ) extends zio.aws.connect.model.ListSecurityProfilePermissionsResponse.ReadOnly {
    override val permissions: Optional[List[SecurityProfilePermission]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.primitives.SecurityProfilePermission(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsResponse
  ): zio.aws.connect.model.ListSecurityProfilePermissionsResponse.ReadOnly =
    new Wrapper(impl)
}
