package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.connect.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListTagsForResourceRequest =
      zio.aws.connect.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: ARN
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListTagsForResourceRequest
  ) extends zio.aws.connect.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListTagsForResourceRequest
  ): zio.aws.connect.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
