package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListTaskTemplatesResponse(
    taskTemplates: Optional[
      Iterable[zio.aws.connect.model.TaskTemplateMetadata]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListTaskTemplatesResponse = {
    import ListTaskTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListTaskTemplatesResponse
      .builder()
      .optionallyWith(
        taskTemplates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.taskTemplates)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListTaskTemplatesResponse.ReadOnly =
    zio.aws.connect.model.ListTaskTemplatesResponse.wrap(buildAwsValue())
}
object ListTaskTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListTaskTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListTaskTemplatesResponse =
      zio.aws.connect.model.ListTaskTemplatesResponse(
        taskTemplates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def taskTemplates
        : Optional[List[zio.aws.connect.model.TaskTemplateMetadata.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getTaskTemplates: ZIO[Any, AwsError, List[
      zio.aws.connect.model.TaskTemplateMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("taskTemplates", taskTemplates)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListTaskTemplatesResponse
  ) extends zio.aws.connect.model.ListTaskTemplatesResponse.ReadOnly {
    override val taskTemplates
        : Optional[List[zio.aws.connect.model.TaskTemplateMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskTemplates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.TaskTemplateMetadata.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListTaskTemplatesResponse
  ): zio.aws.connect.model.ListTaskTemplatesResponse.ReadOnly = new Wrapper(
    impl
  )
}
