package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  NextToken,
  MaxResult10,
  TrafficDistributionGroupIdOrArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTrafficDistributionGroupUsersRequest(
    trafficDistributionGroupId: TrafficDistributionGroupIdOrArn,
    maxResults: Optional[MaxResult10] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersRequest = {
    import ListTrafficDistributionGroupUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersRequest
      .builder()
      .trafficDistributionGroupId(
        TrafficDistributionGroupIdOrArn.unwrap(
          trafficDistributionGroupId
        ): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => MaxResult10.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListTrafficDistributionGroupUsersRequest.ReadOnly =
    zio.aws.connect.model.ListTrafficDistributionGroupUsersRequest
      .wrap(buildAwsValue())
}
object ListTrafficDistributionGroupUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.ListTrafficDistributionGroupUsersRequest =
      zio.aws.connect.model.ListTrafficDistributionGroupUsersRequest(
        trafficDistributionGroupId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def trafficDistributionGroupId: TrafficDistributionGroupIdOrArn
    def maxResults: Optional[MaxResult10]
    def nextToken: Optional[NextToken]
    def getTrafficDistributionGroupId
        : ZIO[Any, Nothing, TrafficDistributionGroupIdOrArn] =
      ZIO.succeed(trafficDistributionGroupId)
    def getMaxResults: ZIO[Any, AwsError, MaxResult10] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersRequest
  ) extends zio.aws.connect.model.ListTrafficDistributionGroupUsersRequest.ReadOnly {
    override val trafficDistributionGroupId: TrafficDistributionGroupIdOrArn =
      zio.aws.connect.model.primitives
        .TrafficDistributionGroupIdOrArn(impl.trafficDistributionGroupId())
    override val maxResults: Optional[MaxResult10] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult10(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersRequest
  ): zio.aws.connect.model.ListTrafficDistributionGroupUsersRequest.ReadOnly =
    new Wrapper(impl)
}
